CONTAINER OtachyonVolumeObject
{
    NAME OtachyonVolumeObject;

    INCLUDE Obase;
    //INCLUDE Obaselist;

    GROUP TACHYON_VOLUME_OBJECT_GROUP_SETTINGS
    {
        DEFAULT 1;

        GROUP TACHYON_VOLUME_OBJECT_SETTINGS_HEADER
        {
            SEPARATOR { LINE; }

		    LONG TACHYON_VOLUME_OBJECT_MODE
		    {
			    ANIM OFF;
			    SCALE_H;
                CUSTOMGUI QUICKTABRADIO;
			    CYCLE
			    {
				    TACHYON_VOLUME_OBJECT_MODE_LAYERED;
                    TACHYON_VOLUME_OBJECT_MODE_CUBE;
			    }
		    }

            SEPARATOR { LINE; }
            //STATICTEXT {}
        }

        GROUP TACHYON_VOLUME_OBJECT_GROUP_COMMON_PROPS
        {
            SEPARATOR { LINE; }

            LONG TACHYON_VOLUME_OBJECT_PRIM_AXIS
		    {
			    CYCLE
			    {
				    TACHYON_VOLUME_OBJECT_PRIM_AXIS_XP;
				    TACHYON_VOLUME_OBJECT_PRIM_AXIS_XN;
				    TACHYON_VOLUME_OBJECT_PRIM_AXIS_YP;
				    TACHYON_VOLUME_OBJECT_PRIM_AXIS_YN;
				    TACHYON_VOLUME_OBJECT_PRIM_AXIS_ZP;
				    TACHYON_VOLUME_OBJECT_PRIM_AXIS_ZN;
			    }
		    }

            REAL TACHYON_VOLUME_OBJECT_COMMON_DENSITY { CUSTOMGUI REALSLIDER; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.1; UNIT PERCENT; }
            REAL TACHYON_VOLUME_OBJECT_COMMON_PHASE { CUSTOMGUI REALSLIDER; MINSLIDER -0.99; MAXSLIDER 0.99; STEP 0.01; }
        }

        GROUP TACHYON_VOLUME_OBJECT_GROUP_LAYERED
        {
            REAL TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_BLEND_RANGE { CUSTOMGUI REALSLIDER; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1000.0; STEP 0.1; UNIT METER; }

            SEPARATOR {}

            GROUP TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_A_GROUP
            {
                DEFAULT 1;
                REAL TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_A_DENSITY { CUSTOMGUI REALSLIDER; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.1; UNIT PERCENT; }
                REAL TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_A_PHASE { CUSTOMGUI REALSLIDER; MINSLIDER -0.99; MAXSLIDER 0.99; STEP 0.01; }

                GROUP
                {
                    COLUMNS 2;
                    BOOL TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_A_CLIP_ENABLED { }
                    REAL TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_A_CLIP_RANGE { UNIT METER; MIN 0.0; }
                }
            }

            GROUP TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_B_GROUP
            {
                DEFAULT 1;
                REAL TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_B_DENSITY { CUSTOMGUI REALSLIDER; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.1; UNIT PERCENT; }
                REAL TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_B_PHASE { CUSTOMGUI REALSLIDER; MINSLIDER -0.99; MAXSLIDER 0.99; STEP 0.01; }

                GROUP
                {
                    COLUMNS 2;
                    BOOL TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_B_CLIP_ENABLED { }
                    REAL TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_B_CLIP_RANGE { UNIT METER; MIN 0.0; }
                }
            }

            SEPARATOR {}

            BUTTON TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_FLIP_BUTTON { ANIM OFF; }
        }

        GROUP TACHYON_VOLUME_OBJECT_GROUP_CUBE
        {
            SEPARATOR {}

            VECTOR TACHYON_VOLUME_OBJECT_CUBE_SIZE { MIN 0 0 0; UNIT METER; CUSTOMGUI SUBDESCRIPTION; }
        }
    }

    GROUP TACHYON_VOLUME_OBJECT_GROUP_NOISE
    {
        BOOL TACHYON_VOLUME_OBJECT_NOISE_ENABLED { }

        GROUP
        {
            LONG TACHYON_VOLUME_OBJECT_NOISE_SPACE
            {
                ALIGN_LEFT;
                CYCLE
                {
                    TACHYON_VOLUME_OBJECT_NOISE_SPACE_OBJECT;
                    TACHYON_VOLUME_OBJECT_NOISE_SPACE_WORLD;
                    TACHYON_VOLUME_OBJECT_NOISE_SPACE_CUSTOM;
                }
            }
        }

        LINK TACHYON_VOLUME_OBJECT_NOISE_ORIGIN_OBJ { SCALE_H; ACCEPT { Obase; } }

        BOOL TACHYON_VOLUME_OBJECT_NOISE_GRADIENT_ENABLED { }
        SPLINE TACHYON_VOLUME_OBJECT_NOISE_GRADIENT { }

        REAL TACHYON_VOLUME_OBJECT_NOISE_OCTAVES { MIN 0; STEP .1; MAX 20; }
        REAL TACHYON_VOLUME_OBJECT_NOISE_LACUNARITY { MIN 0; STEP .1; MAX 20; }
        REAL TACHYON_VOLUME_OBJECT_NOISE_PERSISTENCE { MIN 0; STEP .1; MAX 20; }

        REAL TACHYON_VOLUME_OBJECT_NOISE_SCALE { UNIT PERCENT; MIN 0; }

        REAL TACHYON_VOLUME_OBJECT_NOISE_ANIM_SPEED { MIN 0; STEP .1; UNIT PERCENT; }
        //REAL TACHYON_VOLUME_OBJECT_NOISE_TIMEPERIOD { MIN 0; }

        GROUP TACHYON_VOLUME_OBJECT_NOISE_ANIM_GROUP
        {
            DEFAULT 1;
            GROUP
            {
                LONG TACHYON_VOLUME_OBJECT_NOISE_ANIM_SPACE
                {
                    ALIGN_LEFT;
                    CYCLE
                    {
                        TACHYON_VOLUME_OBJECT_NOISE_SPACE_OBJECT;
                        TACHYON_VOLUME_OBJECT_NOISE_SPACE_WORLD;
                        TACHYON_VOLUME_OBJECT_NOISE_SPACE_CUSTOM;
                    }
                }
            }
            LINK TACHYON_VOLUME_OBJECT_NOISE_ANIM_OBJ { SCALE_H; ACCEPT { Obase; } }

            VECTOR TACHYON_VOLUME_OBJECT_NOISE_MOVEMENT { UNIT METER; FORBID_SCALING; }
            REAL TACHYON_VOLUME_OBJECT_NOISE_SPEED { UNIT PERCENT; }
        }

        GROUP TACHYON_VOLUME_OBJECT_NOISE_ADJUSTMENT_GROUP
        {
            DEFAULT 1;
            REAL TACHYON_VOLUME_OBJECT_NOISE_LOW_CLIP { UNIT PERCENT; MIN 0; MAX 100;  MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
            REAL TACHYON_VOLUME_OBJECT_NOISE_HIGH_CLIP { UNIT PERCENT; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
            REAL TACHYON_VOLUME_OBJECT_NOISE_BRIGHTNESS { UNIT PERCENT; MIN -100; MAX 100; MINSLIDER -100; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
            REAL TACHYON_VOLUME_OBJECT_NOISE_CONTRAST { UNIT PERCENT; MIN -100; MAX 100; MINSLIDER -100; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
        }
    }
}
